﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Glass1View : MonoBehaviour
{
    public MeshRenderer m_strawberryRender;//草莓
    public MeshRenderer m_lemonRender;//柠檬
    public MeshRenderer m_orangeRender;//橙子
    public Transform m_effectPos;//特效位置
    public Vector3 effectPos => m_effectPos.position;

    private float m_strawberryOffest;
    private float m_lemonOffest;
    private float m_orangeOffest;

    private float m_strawberryNum;
    private float m_lemonNum;
    private float m_orangeNum;

    private float m_strawberryMaxNum = 3.0f;
    private float m_lemonMaxNum = 3.0f;
    private float m_orangeMaxNum = 3.0f;

    private bool m_bControl = true;
    private float m_speed = 2.0f;

    private Material m_strawberry;
    private Material m_lemon;
    private Material m_orange;
    private string m_shaderFloatStr = "_FillAmount";//shader参数

    private float m_strawberryValue = 0.0f;
    private float m_lemonValue = 0.0f;
    private float m_orangeValue = 0.0f;

    private void Awake()
    {
        m_strawberry = m_strawberryRender.material;
        m_lemon = m_lemonRender.material;
        m_orange = m_orangeRender.material;
    }
    //数量
    public void SetFruitNum(int num1, int num2, int num3)
    {
        m_strawberryNum += num1;
        if (m_strawberryNum > m_strawberryMaxNum)
        {
            m_strawberryNum = m_strawberryMaxNum;
        }
        m_lemonNum += num2;
        if (m_lemonNum > m_lemonMaxNum)
        {
            m_lemonNum = m_lemonMaxNum;
        }
        m_orangeNum += num3;
        if (m_orangeNum > m_orangeMaxNum)
        {
            m_orangeNum = m_orangeMaxNum;
        }
    }
    private void Update()
    {
        if (!BattleCtrl.instance.isStartBattle || BattleCtrl.instance.isEndBattle)
        {
            return;
        }
        if (m_strawberryOffest < m_strawberryNum)
        {
            m_strawberryOffest += Time.deltaTime * m_speed;
            if(m_lemonOffest > 0)
            {
                if (m_orange.GetFloat(m_shaderFloatStr) > 0.4f)
                {
                    m_orange.SetFloat(m_shaderFloatStr, m_orange.GetFloat(m_shaderFloatStr) - m_strawberryOffest / 1000);
                }
            }
            else
            {
                if(m_orange.GetFloat(m_shaderFloatStr) > 0.5f)
                {
                    m_orange.SetFloat(m_shaderFloatStr, m_orange.GetFloat(m_shaderFloatStr) - m_strawberryOffest / 1000);
                }
            }
            if (m_lemonOffest > 0)
            {
                if (m_lemon.GetFloat(m_shaderFloatStr) > 0.5f)
                {
                    m_lemon.SetFloat(m_shaderFloatStr, m_lemon.GetFloat(m_shaderFloatStr) - m_strawberryOffest / 1000);
                }
            }
            else
            {
                m_lemon.SetFloat(m_shaderFloatStr, m_strawberry.GetFloat(m_shaderFloatStr) - m_lemonOffest / 10);
            }

            m_strawberry.SetFloat(m_shaderFloatStr, 0.9f - m_strawberryOffest/10);
        }
        if (m_lemonOffest < m_lemonNum)
        {
            m_lemonOffest += Time.deltaTime * m_speed;

            if (m_strawberryOffest > 0)
            {
                if (m_orange.GetFloat(m_shaderFloatStr) > 0.4f)
                {
                    m_orange.SetFloat(m_shaderFloatStr, m_orange.GetFloat(m_shaderFloatStr) - m_lemonOffest / 1000);
                }
            }
            else
            {
                if (m_orange.GetFloat(m_shaderFloatStr) > 0.5f)
                {
                    m_orange.SetFloat(m_shaderFloatStr, m_orange.GetFloat(m_shaderFloatStr) - m_lemonOffest / 1000);
                }
            }

            if (m_strawberry.GetFloat(m_shaderFloatStr) >= 1.0f)
            {
                m_lemon.SetFloat(m_shaderFloatStr, 0.9f - m_lemonOffest / 10);
            }
            else
            {
                m_lemon.SetFloat(m_shaderFloatStr, m_strawberry.GetFloat(m_shaderFloatStr) - m_lemonOffest / 30);
            }
                
        }
        if (m_orangeOffest < m_orangeNum && m_orange)
        {
            m_orangeOffest += Time.deltaTime * m_speed;

            if(m_lemon.GetFloat(m_shaderFloatStr) >= 1.0f)
            {
                m_orange.SetFloat(m_shaderFloatStr, 0.9f - m_orangeOffest / 10);
            }
            else
            {
                m_orange.SetFloat(m_shaderFloatStr, m_lemon.GetFloat(m_shaderFloatStr) - m_orangeOffest / 30);
            }
        }
        if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelOneIndex)
        {
            if (m_strawberryOffest >= m_strawberryMaxNum && m_lemonOffest >= m_lemonMaxNum
                && m_bControl)
            {
                m_bControl = false;
                BattleCtrl.instance.OnBattleWin();
            }
        }
        else if (BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelTwoIndex
            || BattleCtrl.instance.levelManager.CurLevelIndex == LevelEnum.levelThreeIndex)
        {
            if (m_strawberryOffest >= m_strawberryMaxNum && m_lemonOffest >= m_lemonMaxNum
                && m_orangeOffest >= m_orangeMaxNum && m_bControl)
            {
                m_bControl = false;
                BattleCtrl.instance.OnBattleWin();
            }
        }
    }
    //private void OnDestroy()
    //{
    //    m_orange.SetFloat(m_shaderFloatStr, 1.0f);
    //    m_lemon.SetFloat(m_shaderFloatStr, 1.0f);
    //    m_strawberry.SetFloat(m_shaderFloatStr, 1.0f);
    //}
}
